(* Przyklady interfejsow *)
structure Demo = struct 
local
	(* Deklaracja interfejsu *)
	_interfacetype ISetter
	with
		set : int -> unit
	end

	(* Cukier *)
	_interfacetype IGetter 
	with
		get : unit -> int
	end

	(* Dziedziczenie *)
	_interfacetype IProperty : ISetter, IGetter
	with
		say : unit -> unit
	end

	_classtype C(x : int) : IProperty 
	with local
		val r = ref x
	in

		(* Implementuje ISetter.set() *)
		set(i : int) = (print ("\nset " ^ Int.toString i);
			     r := i)
		(* Implementuje IGetter.get() *)
		and get() = (print ("\nget");
			!r)
		(* Implementuje IProperty.say() *)       
		and say () = print (Int.toString (!r))
	end
in
fun main(a : string option array option) = 
     let 
	 (* Dziala? *)
	 val c = C(1);

	 (* Rzutowanie na typ interfejsu *)
	 val i = c :> IProperty

	 (* Wywolanie na wartosci interfejsu *)
	 val 1 = i.#get()

	 (* Rzutowanie z wartosci interfejsu na klase *)
	 val d = i :> C

	 (* Wywolanie bezposrednio przez klase *)
	 val 1 = d.#get()

	 val _ = c.#set(2)

	 val 2 = d.#get()

	 val true = d.#Equals(c) 

	 (* Niejawne dziedziczenie elementow object przy typach interfejsu *)
	 val true = i.#Equals(i) 

     in print "\ndone" 
     end
end
end
